#pragma once

#ifndef CVENUMS_h
#define CVENUMS_h

// enums.h

#include "CvDefines.h"

enum DllExport GameStateTypes					
{
	GAMESTATE_ON,
	GAMESTATE_OVER,
	GAMESTATE_EXTENDED,
};

enum DllExport PopupStates						
{
	POPUPSTATE_IMMEDIATE,
	POPUPSTATE_QUEUED,
	POPUPSTATE_MINIMIZED,
};

enum DllExport PopupEventTypes
{
	POPUPEVENT_NONE,
	POPUPEVENT_PRODUCTION,
	POPUPEVENT_WARNING,
	POPUPEVENT_CIVIC,
};

enum DllExport CameraLookAtTypes			
{
	CAMERALOOKAT_NORMAL,
	CAMERALOOKAT_CITY_ZOOM_IN,
	CAMERALOOKAT_BATTLE,
	CAMERALOOKAT_BATTLE_ZOOM_IN,
	CAMERALOOKAT_SHRINE_ZOOM_IN,
	CAMERALOOKAT_IMMEDIATE,
	CAMERALOOKAT_HOTSEAT,
};

enum DllExport CameraMovementSpeeds		
{
	CAMERAMOVEMENTSPEED_NORMAL,
	CAMERAMOVEMENTSPEED_SLOW,
	CAMERAMOVEMENTSPEED_FAST,
};

enum DllExport ZoomLevelTypes					
{
	ZOOM_UNKNOWN							= 0x00000000,
	ZOOM_DETAIL								= 0x00000001,
	ZOOM_NORMAL								= 0x00000002,
	ZOOM_GLOBEVIEW_TRANSITION	= 0x00000004,
	ZOOM_GLOBEVIEW						= 0x00000008
};

enum DllExport ResourceLayerOptions
{
	RESOURCE_LAYER_NATIVE_TRADE,
	RESOURCE_LAYER_NATIVE_TRAIN,
	RESOURCE_LAYER_RESOURCES,

#ifdef _USRDLL
	NUM_RESOURCE_LAYERS,
#endif
};

enum DllExport UnitLayerOptionTypes 
{
	SHOW_ALL_MILITARY,
	SHOW_TEAM_MILITARY,
	SHOW_ENEMIES_IN_TERRITORY,
	SHOW_ENEMIES,
	SHOW_PLAYER_DOMESTICS,

#ifdef _USRDLL
	NUM_UNIT_LAYER_OPTION_TYPES
#endif
};


enum DllExport PlotIndicatorVisibilityFlags
{
	VISIBLE_ALWAYS,
	VISIBLE_ONSCREEN_ONLY,
	VISIBLE_OFFSCREEN_ONLY,
	VISIBLE_ONGLOBE_ONLY,
	VISIBLE_NEVER
};


enum DllExport DirectionTypes					
{
	NO_DIRECTION = -1,

	DIRECTION_NORTH,
	DIRECTION_NORTHEAST,
	DIRECTION_EAST,
	DIRECTION_SOUTHEAST,
	DIRECTION_SOUTH,
	DIRECTION_SOUTHWEST,
	DIRECTION_WEST,
	DIRECTION_NORTHWEST,

#ifdef _USRDLL
	NUM_DIRECTION_TYPES,
#endif

	DIRECTION_NORTH_MASK = 1 << DIRECTION_NORTH,
	DIRECTION_NORTHEAST_MASK = 1 << DIRECTION_NORTHEAST,
	DIRECTION_EAST_MASK = 1 << DIRECTION_EAST,
	DIRECTION_SOUTHEAST_MASK = 1 << DIRECTION_SOUTHEAST,
	DIRECTION_SOUTH_MASK = 1 << DIRECTION_SOUTH,
	DIRECTION_SOUTHWEST_MASK = 1 << DIRECTION_SOUTHWEST,
	DIRECTION_WEST_MASK = 1 << DIRECTION_WEST,
	DIRECTION_NORTHWEST_MASK = 1 << DIRECTION_NORTHWEST,
};

enum DllExport CardinalDirectionTypes			
{
	NO_CARDINALDIRECTION = -1,

	CARDINALDIRECTION_NORTH,
	CARDINALDIRECTION_EAST,
	CARDINALDIRECTION_SOUTH,
	CARDINALDIRECTION_WEST,

#ifdef _USRDLL
	NUM_CARDINALDIRECTION_TYPES
#endif
};

enum DllExport RotationTypes
{
	ROTATE_NONE = 0,
	ROTATE_90CW,
	ROTATE_180CW,
	ROTATE_270CW,
	NUM_ROTATION_TYPES,

	ROTATE_NONE_MASK	= 1 << ROTATE_NONE,
	ROTATE_90CW_MASK	= 1 << ROTATE_90CW,
	ROTATE_180CW_MASK	= 1 << ROTATE_180CW,
	ROTATE_270CW_MASK	= 1 << ROTATE_270CW,
};

// camera wrap helper
enum DllExport WrapDirection
{
	WRAP_SAVE,
	WRAP_NONE = WRAP_SAVE,
	WRAP_RESTORE,
	WRAP_LEFT,
	WRAP_RIGHT,
	WRAP_UP,
	WRAP_DOWN,

#ifdef _USRDLL
	NUM_WRAP_DIRECTIONS,
#endif

	WRAP_LEFT_MASK = 1 << WRAP_LEFT,
	WRAP_RIGHT_MASK = 1 << WRAP_RIGHT,
	WRAP_UP_MASK = 1 << WRAP_UP,
	WRAP_DOWN_MASK = 1 << WRAP_DOWN,
};

enum DllExport ColorTypes						
{
	NO_COLOR = -1,
};

enum DllExport PlayerColorTypes			
{
	NO_PLAYERCOLOR = -1,
};

//Warning: these values correspond to locations in the plot texture [JW]
enum DllExport PlotStyles						
{
	PLOT_STYLE_NONE = -1,

	//first row
	PLOT_STYLE_NUMPAD_1 = 0,
	PLOT_STYLE_NUMPAD_2,
	PLOT_STYLE_NUMPAD_3,
	PLOT_STYLE_NUMPAD_4,
	PLOT_STYLE_NUMPAD_6,
	PLOT_STYLE_NUMPAD_7,
	PLOT_STYLE_NUMPAD_8,
	PLOT_STYLE_NUMPAD_9,

	//second row
	PLOT_STYLE_NUMPAD_1_ANGLED = 8,
	PLOT_STYLE_NUMPAD_2_ANGLED,
	PLOT_STYLE_NUMPAD_3_ANGLED,
	PLOT_STYLE_NUMPAD_4_ANGLED,
	PLOT_STYLE_NUMPAD_6_ANGLED,
	PLOT_STYLE_NUMPAD_7_ANGLED,
	PLOT_STYLE_NUMPAD_8_ANGLED,
	PLOT_STYLE_NUMPAD_9_ANGLED,

	//third row
	PLOT_STYLE_BOX_FILL = 16,
	PLOT_STYLE_BOX_OUTLINE,
	PLOT_STYLE_RIVER_SOUTH,
	PLOT_STYLE_RIVER_EAST,
	PLOT_STYLE_SIDE_ARROWS,
	PLOT_STYLE_CIRCLE,
	PLOT_STYLE_TARGET,
	PLOT_STYLE_DOT_TARGET,

	//fourth row
	PLOT_STYLE_WAVES = 24,
	PLOT_STYLE_DOTS,
	PLOT_STYLE_CIRCLES,
};

//Warning: these values are used as an index into a fixed array
enum DllExport PlotLandscapeLayers		
{
	PLOT_LANDSCAPE_LAYER_ALL = -1,
	PLOT_LANDSCAPE_LAYER_BASE = 0,
	PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS = 1,
	PLOT_LANDSCAPE_LAYER_NUMPAD_HELP = 2,
	PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS = 1,
};

enum DllExport AreaBorderLayers
{
	AREA_BORDER_LAYER_REVEALED_PLOTS,
	AREA_BORDER_LAYER_WORLD_BUILDER,
	AREA_BORDER_LAYER_FOUNDING_BORDER,
	AREA_BORDER_LAYER_CITY_RADIUS,
	AREA_BORDER_LAYER_RANGED,
	AREA_BORDER_LAYER_HIGHLIGHT_PLOT,
	AREA_BORDER_LAYER_EUROPE,
	NUM_AREA_BORDER_LAYERS
};

enum DllExport EffectTypes
{
	NO_EFFECT = -1,
};

enum DllExport AttachableTypes
{
	NO_ATTACHABLE = -1,
};

enum DllExport InterfaceModeTypes			
{
	NO_INTERFACEMODE = -1,

	INTERFACEMODE_SELECTION,
	INTERFACEMODE_PING,
	INTERFACEMODE_SIGN,
	INTERFACEMODE_GRIP,
	INTERFACEMODE_GLOBELAYER_INPUT,
	INTERFACEMODE_GO_TO,
	INTERFACEMODE_GO_TO_TYPE,
	INTERFACEMODE_GO_TO_ALL,
	INTERFACEMODE_ROUTE_TO,
	INTERFACEMODE_PYTHON_PICK_PLOT,
	INTERFACEMODE_SAVE_PLOT_NIFS,

#ifdef _USRDLL
	NUM_INTERFACEMODE_TYPES
#endif
};

enum DllExport InterfaceMessageTypes	
{
	NO_MESSAGE_TYPE = -1,

	MESSAGE_TYPE_INFO,
	MESSAGE_TYPE_LOG_ONLY,
	MESSAGE_TYPE_DISPLAY_ONLY,
	MESSAGE_TYPE_MAJOR_EVENT,
	MESSAGE_TYPE_MINOR_EVENT,
	MESSAGE_TYPE_CHAT,
	MESSAGE_TYPE_COMBAT_MESSAGE,
	MESSAGE_TYPE_QUEST,
	MESSAGE_TYPE_TUTORIAL,

#ifdef _USRDLL
	NUM_INTERFACE_MESSAGE_TYPES
#endif
};

enum DllExport FlyoutTypes
{
	NO_FLYOUT = -1,

	FLYOUT_HURRY,
	FLYOUT_TRAIN,
	FLYOUT_CONSTRUCT,
	FLYOUT_CONVINCE,
	FLYOUT_MOVE_TO,
	FLYOUT_SELECT_UNIT,
	FLYOUT_SELECT_ALL,
	FLYOUT_WAKE_ALL,
	FLYOUR_FORTIFY_ALL,
	FLYOUR_SLEEP_ALL,
};

enum DllExport MinimapModeTypes		
{
	NO_MINIMAPMODE = -1,

	MINIMAPMODE_TERRITORY,
	MINIMAPMODE_TERRAIN,
	MINIMAPMODE_REPLAY,
	MINIMAPMODE_MILITARY,

#ifdef _USRDLL
	NUM_MINIMAPMODE_TYPES
#endif
};

enum DllExport EngineDirtyBits		
{
	GlobeTexture_DIRTY_BIT,
	GlobePartialTexture_DIRTY_BIT,
	MinimapTexture_DIRTY_BIT,
	CultureBorders_DIRTY_BIT,

#ifdef _USRDLL
	NUM_ENGINE_DIRTY_BITS
#endif
};

enum DllExport InterfaceDirtyBits 
{
	SelectionCamera_DIRTY_BIT,
	Fog_DIRTY_BIT,
	GlobeLayer_DIRTY_BIT,
	GlobeInfo_DIRTY_BIT,
	Waypoints_DIRTY_BIT,
	MiscButtons_DIRTY_BIT,
	PlotListButtons_DIRTY_BIT,
	SelectionButtons_DIRTY_BIT,
	CitizenButtons_DIRTY_BIT,
	Event_DIRTY_BIT,
	Center_DIRTY_BIT,
	GameData_DIRTY_BIT,
	Score_DIRTY_BIT,
	TurnTimer_DIRTY_BIT,
	Help_DIRTY_BIT,
	MinimapSection_DIRTY_BIT,
	SelectionSound_DIRTY_BIT,
	Cursor_DIRTY_BIT,
	CityInfo_DIRTY_BIT,
	UnitInfo_DIRTY_BIT,
	Popup_DIRTY_BIT,
	CityScreen_DIRTY_BIT,
	InfoPane_DIRTY_BIT,
	Flag_DIRTY_BIT,
	HighlightPlot_DIRTY_BIT,
	ColoredPlots_DIRTY_BIT,
	Financial_Screen_DIRTY_BIT,
	Foreign_Screen_DIRTY_BIT,
	Soundtrack_DIRTY_BIT,
	Domestic_Advisor_DIRTY_BIT,
	Advanced_Start_DIRTY_BIT,
	EuropeScreen_DIRTY_BIT,
	ResourceTable_DIRTY_BIT,
	TradeRoutesAdvisor_DIRTY_BIT,	// TAC - Trade Routes Advisor - koma13

#ifdef _USRDLL
	NUM_INTERFACE_DIRTY_BITS
#endif
};
enum DllExport WidgetTypes
{
	WIDGET_PLOT_LIST,
	WIDGET_PLOT_LIST_SHIFT,
	WIDGET_CITY_SCROLL,
	WIDGET_LIBERATE_CITY,
	WIDGET_CITY_NAME,
	WIDGET_UNIT_NAME,
	WIDGET_CREATE_GROUP,
	WIDGET_DELETE_GROUP,
	WIDGET_TRAIN,
	WIDGET_CONSTRUCT,
	WIDGET_CONVINCE,
	WIDGET_HURRY,
	WIDGET_PLAYER_HURRY,
	WIDGET_MENU_ICON,
	WIDGET_ACTION,
	WIDGET_CITIZEN,
	WIDGET_CONTACT_CIV,
	WIDGET_SCORE_BREAKDOWN,
	WIDGET_ZOOM_CITY,
	WIDGET_END_TURN,
	WIDGET_AUTOMATE_CITIZENS,
	WIDGET_AUTOMATE_PRODUCTION,
	WIDGET_EMPHASIZE,
	WIDGET_DIPLOMACY_RESPONSE,
	WIDGET_GENERAL,
	WIDGET_FILE_LISTBOX,
	WIDGET_FILE_EDITBOX,
	WIDGET_WB_UNITNAME_EDITBOX,
	WIDGET_WB_CITYNAME_EDITBOX,
	WIDGET_WB_SAVE_BUTTON,
	WIDGET_WB_LOAD_BUTTON,
	WIDGET_WB_ALL_PLOTS_BUTTON,
	WIDGET_WB_LANDMARK_BUTTON,
	WIDGET_WB_ERASE_BUTTON,
	WIDGET_WB_EXIT_BUTTON,
	WIDGET_WB_UNIT_EDIT_BUTTON,
	WIDGET_WB_CITY_EDIT_BUTTON,
	WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON,
	WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON,
	WIDGET_WB_REVEAL_TAB_MODE_BUTTON,
	WIDGET_WB_DIPLOMACY_MODE_BUTTON,
	WIDGET_WB_REVEAL_ALL_BUTTON,
	WIDGET_WB_UNREVEAL_ALL_BUTTON,
	WIDGET_WB_REGENERATE_MAP,
	WIDGET_TRADE_ITEM,
	WIDGET_UNIT_MODEL,
	WIDGET_POPUP_QUEUE,

	//	This is meant for python buttons, it will call python functions for display and execution
	WIDGET_PYTHON,

	//	This button type is reserved for widgets meant to be displayed only.  This is meant for general interface text and such...
	WIDGET_HELP_DEFENSE,
	WIDGET_HELP_POPULATION,
	WIDGET_HELP_REBEL,
	WIDGET_HELP_GREAT_GENERAL,
	WIDGET_HELP_SELECTED,
	WIDGET_HELP_YIELD,
	WIDGET_HELP_PROMOTION,
	WIDGET_HELP_UNIT_PROMOTION,

	WIDGET_CHOOSE_EVENT,
	WIDGET_PEDIA_JUMP_TO_UNIT,
	WIDGET_PEDIA_JUMP_TO_PROFESSION,
	WIDGET_PEDIA_JUMP_TO_BUILDING,
	WIDGET_PEDIA_BACK,
	WIDGET_PEDIA_FORWARD,
	WIDGET_PEDIA_JUMP_TO_BONUS,
	WIDGET_PEDIA_MAIN,
	WIDGET_PEDIA_JUMP_TO_PROMOTION,
	WIDGET_PEDIA_JUMP_TO_IMPROVEMENT,
	WIDGET_PEDIA_JUMP_TO_CIVIC,
	WIDGET_PEDIA_JUMP_TO_CIV,
	WIDGET_PEDIA_JUMP_TO_LEADER,
	WIDGET_PEDIA_JUMP_TO_TERRAIN,
	WIDGET_PEDIA_JUMP_TO_YIELDS,
	WIDGET_PEDIA_JUMP_TO_FEATURE,
	WIDGET_PEDIA_JUMP_TO_FATHER,
	WIDGET_TURN_EVENT,
	WIDGET_PEDIA_DESCRIPTION,
	WIDGET_PEDIA_DESCRIPTION_NO_HELP,
	WIDGET_DEAL_KILL,
	WIDGET_MINIMAP_HIGHLIGHT,
	WIDGET_PRODUCTION_MOD_HELP,
	WIDGET_LEADERHEAD,
	WIDGET_LEADER_LINE,
	WIDGET_CLOSE_SCREEN,
	WIDGET_GLOBELAYER,
	WIDGET_GLOBELAYER_OPTION,
	WIDGET_GLOBELAYER_TOGGLE,
	WIDGET_CITY_UNIT_ASSIGN_PROFESSION,
	WIDGET_MOVE_CARGO_TO_CITY,
	WIDGET_RECEIVE_MOVE_CARGO_TO_CITY,
	WIDGET_MOVE_CARGO_TO_TRANSPORT,
	WIDGET_RECEIVE_MOVE_CARGO_TO_TRANSPORT,
	WIDGET_CREATE_TRADE_ROUTE,
	WIDGET_EDIT_TRADE_ROUTE,
	WIDGET_YIELD_IMPORT_EXPORT,
	WIDGET_ASSIGN_CITIZEN_TO_PLOT,
	WIDGET_ASSIGN_TRADE_ROUTE,
	WIDGET_EJECT_CITIZEN,
	WIDGET_SHIP_CARGO,
	WIDGET_DOCK,
	WIDGET_SAIL,
	WIDGET_GOTO_CITY,

#ifdef _USRDLL
	NUM_WIDGET_TYPES
#endif
};

enum DllExport ButtonPopupTypes			
{
	BUTTONPOPUP_TEXT,
	BUTTONPOPUP_MAIN_MENU,
	BUTTONPOPUP_CONFIRM_MENU,
	BUTTONPOPUP_DECLAREWARMOVE,
	BUTTONPOPUP_CONFIRMCOMMAND,
	BUTTONPOPUP_CONFIRMTASK,
	BUTTONPOPUP_LOADUNIT,
	BUTTONPOPUP_LOAD_CARGO,
	BUTTONPOPUP_LEADUNIT,
	BUTTONPOPUP_RAZECITY,
	BUTTONPOPUP_CHOOSEPRODUCTION,
	BUTTONPOPUP_CHOOSE_YIELD_BUILD,
	BUTTONPOPUP_CHOOSE_EDUCATION,
	BUTTONPOPUP_ALARM,
	BUTTONPOPUP_DEAL_CANCELED,
	BUTTONPOPUP_PYTHON,
	BUTTONPOPUP_FEAT,
	BUTTONPOPUP_PYTHON_SCREEN,
	BUTTONPOPUP_MOVIE,
	BUTTONPOPUP_DETAILS,
	BUTTONPOPUP_ADMIN,
	BUTTONPOPUP_ADMIN_PASSWORD,
	BUTTONPOPUP_EXTENDED_GAME,
	BUTTONPOPUP_DIPLOMACY,
	BUTTONPOPUP_ADDBUDDY,
	BUTTONPOPUP_FORCED_DISCONNECT,
	BUTTONPOPUP_PITBOSS_DISCONNECT,
	BUTTONPOPUP_KICKED,
	BUTTONPOPUP_EVENT,
	BUTTONPOPUP_FREE_COLONY,
	BUTTONPOPUP_CHOOSE_PROFESSION,
	BUTTONPOPUP_PURCHASE_EUROPE_UNIT,
	BUTTONPOPUP_FOUNDING_FATHER,
	BUTTONPOPUP_CIVIC_OPTION,
	BUTTONPOPUP_TRADE_ROUTES,
	BUTTONPOPUP_YIELD_IMPORT_EXPORT,
	BUTTONPOPUP_PROMOTE,
	BUTTONPOPUP_CHOOSE_GOODY,
	BUTTONPOPUP_SELECT_YIELD_AMOUNT,
	BUTTONPOPUP_EUROPE_UNIT,
	BUTTONPOPUP_TALK_NATIVES,
	// PatchMod: Achievements START
	BUTTONPOPUP_ACHIEVEMENTS,
	// PatchMod: Achievements END
	BUTTONPOPUP_GOTO_MENU,		// TAC - Goto Menu - koma13
	
#ifdef _USRDLL
	NUM_BUTTONPOPUP_TYPES
#endif
};

enum DllExport ClimateTypes					
{
	NO_CLIMATE = -1,
};

enum DllExport SeaLevelTypes				
{
	NO_SEALEVEL = -1,
};

enum DllExport EuropeTypes				
{
	NO_EUROPE = -1,
};

enum DllExport CustomMapOptionTypes	
{
	NO_CUSTOM_MAPOPTION = -1,
};

enum DllExport WorldSizeTypes				
{
	NO_WORLDSIZE = -1,

	WORLDSIZE_TINY,
	WORLDSIZE_SMALL,
	WORLDSIZE_STANDARD,
	WORLDSIZE_LARGE,
	WORLDSIZE_HUGE,

#ifdef _USRDLL
	NUM_WORLDSIZE_TYPES
#endif
};

// This is our current relationship with each 
// one of our connected network peers
enum DllExport InitStates
{
	INIT_INACTIVE,
	INIT_CONNECTED,
	INIT_SENT_READY,
	INIT_READY,
	INIT_ASSIGNED_ID,
	INIT_SENT_ID,
	INIT_PEER,
	INIT_FILE_TRANSFER,
	INIT_TRANSFER_COMPLETE,
	INIT_AUTHORIZED,
	INIT_MAP_CONFIRMED,
	INIT_GAME_STARTED,
};

enum DllExport TerrainTypes						
{
	NO_TERRAIN = -1,
};

enum DllExport PlotTypes							
{
	NO_PLOT = -1,

	PLOT_PEAK,
	PLOT_HILLS,
	PLOT_LAND,
	PLOT_OCEAN,

#ifdef _USRDLL
	NUM_PLOT_TYPES
#endif
};

enum DllExport YieldTypes							
{
	NO_YIELD = -1,

	YIELD_FOOD,
	YIELD_LUMBER,
	YIELD_SILVER,
	YIELD_COCOA,  //ray17
	YIELD_COTTON,
	YIELD_FUR,
	YIELD_SUGAR,
	YIELD_TOBACCO,
	YIELD_WHALE_BLUBBER, //TAC Whaling, ray
	YIELD_ORE,
	YIELD_CLOTH,
	YIELD_COATS,
	YIELD_RUM,
	YIELD_CIGARS,
	YIELD_WHALE_OIL, //TAC Whaling, ray
	YIELD_TOOLS,
	YIELD_MUSKETS,
	YIELD_HORSES,
	YIELD_TRADE_GOODS,
	YIELD_HAMMERS,
	YIELD_BELLS,
	YIELD_CROSSES,
	YIELD_EDUCATION,

#ifdef _USRDLL
	NUM_YIELD_TYPES
#endif
};

enum DllExport EmphasizeTypes					
{
	NO_EMPHASIZE = -1,
};

enum DllExport GameOptionTypes				
{
	NO_GAMEOPTION = -1,

	GAMEOPTION_ADVANCED_START,
	GAMEOPTION_REDUCED_REF, // TAC - Reduced REF Option - koma13
	GAMEOPTION_NO_CITY_RAZING,
	GAMEOPTION_AGGRESSIVE_AI,
	GAMEOPTION_LEAD_ANY_CIV,
	GAMEOPTION_PERMANENT_ALLIANCES,
	GAMEOPTION_ALWAYS_WAR,
	GAMEOPTION_ALWAYS_PEACE,
	GAMEOPTION_ONE_CITY_CHALLENGE,
	GAMEOPTION_NO_CHANGING_WAR_PEACE,
	GAMEOPTION_NEW_RANDOM_SEED,
	GAMEOPTION_LOCK_MODS,
	GAMEOPTION_NO_GOODY_HUTS,
	GAMEOPTION_NO_EVENTS,

#ifdef _USRDLL
	NUM_GAMEOPTION_TYPES
#endif
};

enum DllExport MultiplayerOptionTypes		
{
	NO_MPOPTION = -1,

	MPOPTION_SIMULTANEOUS_TURNS,
	MPOPTION_TAKEOVER_AI,
	MPOPTION_SHUFFLE_TEAMS,
	MPOPTION_ANONYMOUS,
	MPOPTION_TURN_TIMER,

#ifdef _USRDLL
	NUM_MPOPTION_TYPES
#endif
};

enum DllExport SpecialOptionTypes			
{
	NO_SPECIALOPTION = -1,

	SPECIALOPTION_REPORT_STATS,

#ifdef _USRDLL
	NUM_SPECIALOPTION_TYPES
#endif
};

enum DllExport PlayerOptionTypes			
{
	NO_PLAYEROPTION = -1,

	PLAYEROPTION_TUTORIAL,
	PLAYEROPTION_ADVISOR_POPUPS,
	PLAYEROPTION_ADVISOR_HELP,
	PLAYEROPTION_WAIT_END_TURN,
	PLAYEROPTION_MINIMIZE_POP_UPS,
	PLAYEROPTION_SHOW_FRIENDLY_MOVES,
	PLAYEROPTION_SHOW_ENEMY_MOVES,
	PLAYEROPTION_QUICK_MOVES,
	PLAYEROPTION_QUICK_ATTACK,
	PLAYEROPTION_QUICK_DEFENSE,
	PLAYEROPTION_STACK_ATTACK,
	PLAYEROPTION_AUTO_PROMOTION,
	PLAYEROPTION_SAFE_AUTOMATION,
	PLAYEROPTION_NUMPAD_HELP,
	PLAYEROPTION_NO_UNIT_CYCLING,
	PLAYEROPTION_NO_UNIT_RECOMMENDATIONS,
	PLAYEROPTION_RIGHT_CLICK_MENU,
	PLAYEROPTION_LEAVE_FORESTS,
	PLAYEROPTION_MODDER_1,
	PLAYEROPTION_MODDER_2,
	PLAYEROPTION_MODDER_3,

#ifdef _USRDLL
	NUM_PLAYEROPTION_TYPES
#endif
};

enum DllExport GraphicOptionTypes			
{
	NO_GRAPHICOPTION = -1,

	GRAPHICOPTION_HEALTH_BARS,
	GRAPHICOPTION_NO_COMBAT_ZOOM,
	GRAPHICOPTION_NO_ENEMY_GLOW,
	GRAPHICOPTION_FROZEN_ANIMATIONS,
	GRAPHICOPTION_EFFECTS_DISABLED,
	GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED,
	GRAPHICOPTION_FULLSCREEN,
	GRAPHICOPTION_LOWRES_TEXTURES,
	GRAPHICOPTION_HIRES_TERRAIN,
	GRAPHICOPTION_NO_MOVIES,

#ifdef _USRDLL
	NUM_GRAPHICOPTION_TYPES
#endif
};

enum DllExport ForceControlTypes			
{
	NO_FORCECONTROL = -1,

	FORCECONTROL_SPEED,
	FORCECONTROL_HANDICAP,
	FORCECONTROL_OPTIONS,
	FORCECONTROL_VICTORIES,
	FORCECONTROL_MAX_TURNS,
	FORCECONTROL_MAX_CITY_ELIMINATION,
	FORCECONTROL_ADVANCED_START,

#ifdef _USRDLL
	NUM_FORCECONTROL_TYPES
#endif
};

enum DllExport TileArtTypes
{
	TILE_ART_TYPE_NONE = -1,
	TILE_ART_TYPE_TREES,
	TILE_ART_TYPE_HALF_TILING,
	NUM_TILE_ART_TYPES
};

enum DllExport TerrainGroupTypes
{
	TERRAIN_GROUP_NONE = -1,
	TERRAIN_GROUP_OCEAN,
	TERRAIN_GROUP_COAST,
	TERRAIN_GROUP_LAND,
	NUM_TERRAIN_GROUP_TYPES
};

enum DllExport VictoryTypes					
{
	NO_VICTORY = -1,
};

enum DllExport FeatureTypes					
{
	NO_FEATURE = -1,
};

enum DllExport BonusTypes						
{
	NO_BONUS = -1,
};

enum DllExport ImprovementTypes			
{
	NO_IMPROVEMENT = -1,
};

enum DllExport RouteTypes						
{
	NO_ROUTE = -1,
};

enum DllExport GoodyTypes						
{
	NO_GOODY = -1,
};

enum DllExport BuildTypes						
{
	NO_BUILD = -1,
};

enum DllExport FontSymbols					
{
	// 'OTHER' symbols
	HAPPY_CHAR = 0,
	UNHAPPY_CHAR,
	HEALTHY_CHAR,
	UNHEALTHY_CHAR,
	BULLET_CHAR,
	STRENGTH_CHAR,
	MOVES_CHAR,
	RELIGION_CHAR,
	STAR_CHAR,
	SILVER_STAR_CHAR,
	TRADE_CHAR,
	DEFENSE_CHAR,
	GREAT_PEOPLE_CHAR,
	BAD_GOLD_CHAR,
	BAD_FOOD_CHAR,
	EATEN_FOOD_CHAR,
	GOLDEN_AGE_CHAR,
	ANGRY_POP_CHAR,
	OPEN_BORDERS_CHAR,
	DEFENSIVE_PACT_CHAR,
	MAP_CHAR,
	OCCUPATION_CHAR,
	REBEL_CHAR,
	GOLD_CHAR,
	POWER_CHAR,
	// TAC - Trade Routes Advisor - koma13 - START
	CHECKBOX_CHAR,	
	CHECKBOX_SELECTED_CHAR,
	ANCHOR_CHAR,
	ANCHOR_EUROPE_CHAR,
	EXPORT_CHAR,
	IMPORT_CHAR,
	EXPORT_IMPORT_CHAR,
	NO_ANCHOR_CHAR,
	// TAC - Trade Routes Advisor - koma13 - END

#ifdef _USRDLL
	MAX_NUM_SYMBOLS
#endif
};

enum DllExport HandicapTypes				
{
	NO_HANDICAP = -1,
};

enum DllExport GameSpeedTypes				
{
	NO_GAMESPEED = -1,
};

enum DllExport TurnTimerTypes				
{
	NO_TURNTIMER = -1,
};

enum DllExport EraTypes							
{
	NO_ERA = -1,
};

enum DllExport CivilizationTypes		
{
	NO_CIVILIZATION = -1,
};

enum DllExport LeaderHeadTypes			
{
	NO_LEADER = -1,
};

// Used for managing Art Differences based on nationality
enum DllExport ArtStyleTypes				
{
	NO_ARTSTYLE = -1,
};

//Androrc UnitArtStyles
enum DllExport UnitArtStyleTypes
{
	NO_UNIT_ARTSTYLE = -1,
};
//Androrc End

enum DllExport CitySizeTypes				
{
	NO_CITYSIZE = -1,

	CITYSIZE_SMALL,
	CITYSIZE_MEDIUM,
	CITYSIZE_LARGE,

#ifdef _USRDLL
	NUM_CITYSIZE_TYPES
#endif
};

enum DllExport FootstepAudioTypes		
{
	NO_FOOTSTEPAUDIO = -1,
};

enum DllExport FootstepAudioTags		
{
	NO_FOOTSTEPAUDIO_TAG = -1,
};

enum DllExport ChatTargetTypes			
{
	NO_CHATTARGET = -1,
	CHATTARGET_ALL = -2,
	CHATTARGET_TEAM = -3,
};

enum DllExport VoiceTargetTypes			
{
	NO_VOICETARGET = -1,

	VOICETARGET_DIPLO,
	VOICETARGET_TEAM,
	VOICETARGET_ALL,

#ifdef _USRDLL
	NUM_VOICETARGETS
#endif
};

enum DllExport TeamTypes					
{
	UNKNOWN_TEAM = -2,
	NO_TEAM = -1,
};

enum DllExport PlayerTypes				
{
	UNKNOWN_PLAYER = -2,
	NO_PLAYER = -1,
};

enum DllExport TraitTypes					
{
	NO_TRAIT = -1,
};

enum DllExport OrderTypes					
{
	NO_ORDER = -1,

	ORDER_TRAIN,
	ORDER_CONSTRUCT,
	ORDER_CONVINCE,

#ifdef _USRDLL
	NUM_ORDER_TYPES
#endif
};

enum DllExport TaskTypes				
{
	TASK_RAZE,
	TASK_GIFT,
	TASK_SET_ALL_CITIZENS_AUTOMATED,
	TASK_SET_CITIZEN_AUTOMATED,
	TASK_SET_AUTOMATED_PRODUCTION,
	TASK_SET_EMPHASIZE,
	TASK_CHANGE_WORKING_PLOT,
	TASK_CHANGE_PROFESSION,
	TASK_EJECT_TO_TRANSPORT,
	TASK_REPLACE_CITIZEN,
	TASK_CLEAR_WORKING_OVERRIDE,
	TASK_HURRY,
	TASK_CLEAR_ORDERS,
	TASK_RALLY_PLOT,
	TASK_CLEAR_RALLY_PLOT,
	TASK_LIBERATE,
	TASK_YIELD_IMPORT,
	TASK_YIELD_EXPORT,
	TASK_YIELD_LEVEL,
	TASK_CLEAR_SPECIALTY,
	TASK_EDUCATE,
	TASK_PUSH_TRAIN_UNIT,
	TASK_PUSH_CONSTRUCT_BUILDING,
	TASK_CHEAT,

#ifdef _USRDLL
	NUM_TASK_TYPES
#endif
};

enum DllExport PlayerActionTypes				
{
	PLAYER_ACTION_BUY_EUROPE_UNIT,
	PLAYER_ACTION_SELL_YIELD_UNIT,
	PLAYER_ACTION_BUY_YIELD_UNIT,
	PLAYER_ACTION_LOAD_UNIT_FROM_EUROPE,
	PLAYER_ACTION_UNLOAD_UNIT_TO_EUROPE,
	PLAYER_ACTION_TRANSFER_UNIT_IN_EUROPE,
	PLAYER_ACTION_SET_OPTION,
	PLAYER_ACTION_AUTO_MOVES,
	PLAYER_ACTION_TURN_COMPLETE,
	PLAYER_ACTION_APPLY_EVENT,
	PLAYER_ACTION_CONVINCE_FATHER,
	PLAYER_ACTION_SET_CIVIC,
	PLAYER_ACTION_RECEIVE_GOODY,
	PLAYER_ACTION_BUY_UNITS_FROM_KING,
	PLAYER_ACTION_HURRY,
	PLAYER_ACTION_EUROPE_CHANGE_PROFESSION,
	PLAYER_ACTION_FEAT,

#ifdef _USRDLL
	NUM_PLAYER_ACTION_TYPES
#endif
};

enum DllExport BuildingClassTypes				 
{
	NO_BUILDINGCLASS = -1,
};

enum DllExport BuildingTypes						
{
	NO_BUILDING = -1,
};

enum DllExport SpecialBuildingTypes			
{
	NO_SPECIALBUILDING = -1,
};

enum DllExport AxisTypes
{
	AXIS_X,
	AXIS_Y,
	AXIS_Z,
	NUM_AXIS_TYPES
};

enum DllExport InfoBarTypes				
{
	INFOBAR_STORED,
	INFOBAR_RATE,
	INFOBAR_RATE_EXTRA,
	INFOBAR_EMPTY,

#ifdef _USRDLL
	NUM_INFOBAR_TYPES
#endif
};

enum DllExport HealthBarTypes			
{
	HEALTHBAR_ALIVE_ATTACK,
	HEALTHBAR_ALIVE_DEFEND,
	HEALTHBAR_DEAD,

#ifdef _USRDLL
	NUM_HEALTHBAR_TYPES
#endif
};

enum DllExport ConceptTypes				
{
	NO_CONCEPT = -1,
};

enum DllExport CalendarTypes			
{
	NO_CALENDAR = -1, 

	CALENDAR_DEFAULT,
	CALENDAR_BI_YEARLY,
	CALENDAR_YEARS,
	CALENDAR_TURNS,
	CALENDAR_SEASONS,
	CALENDAR_MONTHS,
	CALENDAR_WEEKS,
};

enum DllExport SeasonTypes				
{
	NO_SEASON = -1,
};

enum DllExport MonthTypes					
{
	NO_MONTH = -1,
};

enum DllExport DenialTypes				
{
	NO_DENIAL = -1,

	DENIAL_UNKNOWN,
	DENIAL_NEVER,
	DENIAL_TOO_MUCH,
	DENIAL_MYSTERY,
	DENIAL_JOKING,
	DENIAL_CONTACT_THEM,
	DENIAL_VICTORY,
	DENIAL_ATTITUDE,
	DENIAL_ATTITUDE_THEM,
	DENIAL_POWER_US,
	DENIAL_POWER_YOU,
	DENIAL_POWER_THEM,
	DENIAL_TOO_MANY_WARS,
	DENIAL_NO_GAIN,
	DENIAL_NOT_INTERESTED,
	DENIAL_NOT_ALLIED,
	DENIAL_RECENT_CANCEL,
	DENIAL_WORST_ENEMY,
	DENIAL_POWER_YOUR_ENEMIES,
	DENIAL_TOO_FAR,
	DENIAL_WAR_NOT_POSSIBLE_US,
	DENIAL_WAR_NOT_POSSIBLE_YOU,
	DENIAL_PEACE_NOT_POSSIBLE_US,
	DENIAL_PEACE_NOT_POSSIBLE_YOU,

#ifdef _USRDLL
	NUM_DENIAL_TYPES
#endif
};

enum DllExport DomainTypes			
{
	NO_DOMAIN = -1,

	DOMAIN_SEA,
	DOMAIN_LAND,
	DOMAIN_IMMOBILE,

#ifdef _USRDLL
	NUM_DOMAIN_TYPES
#endif
};

enum DllExport UnitClassTypes		
{
	NO_UNITCLASS = -1,
};

enum DllExport UnitTypes				
{
	NO_UNIT = -1,
};

enum DllExport ProfessionTypes
{
	INVALID_PROFESSION = -2,
	NO_PROFESSION = -1,
};

enum DllExport SpecialUnitTypes	
{
	NO_SPECIALUNIT = -1,
};

enum DllExport UnitCombatTypes	
{
	NO_UNITCOMBAT = -1,
};

enum DllExport UnitAITypes			
{
	NO_UNITAI = -1,

	UNITAI_UNKNOWN,
	UNITAI_COLONIST,
	UNITAI_SETTLER,
	UNITAI_WORKER,
	UNITAI_MISSIONARY,
	UNITAI_SCOUT,
	UNITAI_WAGON,
	UNITAI_TREASURE,
	UNITAI_YIELD,
	UNITAI_GENERAL,
	UNITAI_DEFENSIVE,
	UNITAI_OFFENSIVE,
	UNITAI_COUNTER,
	UNITAI_WORKER_SEA, //TAC Whaling, ray
	UNITAI_TRANSPORT_SEA,
	UNITAI_ASSAULT_SEA,
	UNITAI_COMBAT_SEA,
	UNITAI_PIRATE_SEA,
	UNITAI_ESCORT_SEA, // TAC - AI Assault Sea - koma13

#ifdef _USRDLL
	NUM_UNITAI_TYPES
#endif
};

enum DllExport InvisibleTypes			
{
	NO_INVISIBLE = -1,
};

enum DllExport ProbabilityTypes		
{
	NO_PROBABILITY = -1,

	PROBABILITY_LOW,
	PROBABILITY_REAL,
	PROBABILITY_HIGH,

#ifdef _USRDLL
	NUM_PROBABILITY_TYPES
#endif
};

enum DllExport ActivityTypes			
{
	NO_ACTIVITY = -1,

	ACTIVITY_AWAKE,
	ACTIVITY_HOLD,
	ACTIVITY_SLEEP,
	ACTIVITY_HEAL,
	ACTIVITY_SENTRY,
	ACTIVITY_MISSION,

#ifdef _USRDLL
	NUM_ACTIVITY_TYPES
#endif
};

enum DllExport AutomateTypes			
{
	NO_AUTOMATE = -1,

	AUTOMATE_BUILD,
	AUTOMATE_CITY,
	AUTOMATE_EXPLORE,
	AUTOMATE_SAIL,
	AUTOMATE_TRANSPORT_ROUTES,
	AUTOMATE_TRANSPORT_FULL,
	AUTOMATE_WORKER_SEA, //TAC Whaling, ray
	AUTOMATE_FULL,

#ifdef _USRDLL
	NUM_AUTOMATE_TYPES
#endif
};

// any additions need to be reflected in GlobalTypes.xml
enum DllExport MissionTypes				
{
	NO_MISSION = -1,

	MISSION_MOVE_TO,
	MISSION_ROUTE_TO,
	MISSION_MOVE_TO_UNIT,
	MISSION_SKIP,
	MISSION_SLEEP,
	MISSION_FORTIFY,
	MISSION_HEAL,
	MISSION_SENTRY,
	MISSION_BOMBARD,
	MISSION_PILLAGE,
	MISSION_FOUND,
	MISSION_JOIN_CITY,
	MISSION_BUILD,
	MISSION_LEAD,

	MISSION_BEGIN_COMBAT,
	MISSION_END_COMBAT,
	MISSION_SURRENDER,
	MISSION_CAPTURED,
	MISSION_IDLE,
	MISSION_DIE,
	MISSION_DAMAGE,
	MISSION_MULTI_SELECT,
	MISSION_MULTI_DESELECT,
	MISSION_WHALING, //TAC Whaling, ray

#ifdef _USRDLL
	NUM_MISSION_TYPES
#endif
};

enum DllExport MissionAITypes		
{
	NO_MISSIONAI = -1,

	MISSIONAI_SHADOW,
	MISSIONAI_GROUP,
	MISSIONAI_LOAD_ASSAULT,
	MISSIONAI_LOAD_SETTLER,
	MISSIONAI_LOAD_SPECIAL,
	MISSIONAI_GUARD_CITY,
	MISSIONAI_GUARD_BONUS,
	MISSIONAI_GUARD_TRADE_NET,
	MISSIONAI_SPREAD,
	MISSIONAI_EXPLORE,
	MISSIONAI_PILLAGE,
	MISSIONAI_FOUND,
	MISSIONAI_BUILD,
	MISSIONAI_ASSAULT,
	MISSIONAI_PICKUP,
	MISSIONAI_AWAIT_PICKUP,
	MISSIONAI_SAIL_TO_EUROPE,
	MISSIONAI_SAIL_FROM_EUROPE,
	MISSIONAI_WORKER_SEA, //TAC Whaling, ray
	MISSIONAI_TRANSPORT,
	MISSIONAI_TRANSPORT_SEA,
	MISSIONAI_PIRACY,
	MISSIONAI_BOMBARD,
	MISSIONAI_LEARN,

#ifdef _USRDLL
	NUM_MISSIONAI_TYPES
#endif
};

// any additions need to be reflected in GlobalTypes.xml
enum DllExport CommandTypes					
{
	NO_COMMAND = -1,

	COMMAND_PROMOTION,
	COMMAND_UPGRADE,
	COMMAND_AUTOMATE,
	COMMAND_WAKE,
	COMMAND_CANCEL,
	COMMAND_CANCEL_ALL,
	COMMAND_STOP_AUTOMATION,
	COMMAND_DELETE,
	COMMAND_GIFT,
	COMMAND_LOAD,
	COMMAND_LOAD_UNIT,
	COMMAND_LOAD_CARGO,
	COMMAND_LOAD_YIELD,
	COMMAND_UNLOAD,
	COMMAND_UNLOAD_ALL,
	COMMAND_LEARN,
	COMMAND_KING_TRANSPORT,
	COMMAND_ESTABLISH_MISSION,
	COMMAND_SPEAK_WITH_CHIEF,
	COMMAND_YIELD_TRADE,
	COMMAND_SAIL_TO_EUROPE,
	COMMAND_CHOOSE_TRADE_ROUTES,
	COMMAND_ASSIGN_TRADE_ROUTE,
	COMMAND_PROMOTE,
	COMMAND_PROFESSION,
	COMMAND_CLEAR_SPECIALTY,
	COMMAND_HOTKEY,
	COMMAND_GOTO_MENU,	// TAC - Goto Menu - koma13
	COMMAND_IGNORE_DANGER,	// TAC - Trade Routes Advisor - koma13

#ifdef _USRDLL
	NUM_COMMAND_TYPES
#endif
};

enum DllExport ControlTypes					
{
	NO_CONTROL = -1,

	CONTROL_CENTERONSELECTION,
	CONTROL_SELECTYUNITTYPE,
	CONTROL_SELECTYUNITALL,
	CONTROL_SELECTCITY,
	CONTROL_SELECTCAPITAL,
	CONTROL_NEXTCITY,
	CONTROL_PREVCITY,
	CONTROL_NEXTUNIT,
	CONTROL_PREVUNIT,
	CONTROL_CYCLEUNIT,
	CONTROL_CYCLEUNIT_ALT,
	CONTROL_LASTUNIT,
	CONTROL_ENDTURN,
	CONTROL_ENDTURN_ALT,
	CONTROL_FORCEENDTURN,
	CONTROL_AUTOMOVES,
	CONTROL_PING,
	CONTROL_SIGN,
	CONTROL_GRID,
	CONTROL_BARE_MAP,
	CONTROL_YIELDS,
	CONTROL_RESOURCE_ALL,
	CONTROL_UNIT_ICONS,
	CONTROL_GLOBELAYER,
	CONTROL_SCORES,
	CONTROL_LOAD_GAME,
	CONTROL_OPTIONS_SCREEN,
	CONTROL_RETIRE,
	CONTROL_SAVE_GROUP,
	CONTROL_SAVE_NORMAL,
	CONTROL_QUICK_SAVE,
	CONTROL_QUICK_LOAD,
	CONTROL_ORTHO_CAMERA,
	CONTROL_CYCLE_CAMERA_FLYING_MODES,
	CONTROL_ISOMETRIC_CAMERA_LEFT,
	CONTROL_ISOMETRIC_CAMERA_RIGHT,
	CONTROL_FLYING_CAMERA,
	CONTROL_MOUSE_FLYING_CAMERA,
	CONTROL_TOP_DOWN_CAMERA,
	CONTROL_CIVILOPEDIA,
	CONTROL_FOREIGN_SCREEN,
	CONTROL_CONGRESS_SCREEN,
	CONTROL_REVOLUTION_SCREEN,
	CONTROL_EUROPE_SCREEN,
	CONTROL_MILITARY_SCREEN,
	CONTROL_FATHER_SCREEN,
	CONTROL_TURN_LOG,
	CONTROL_CHAT_ALL,
	CONTROL_CHAT_TEAM,
	CONTROL_DOMESTIC_SCREEN,
	CONTROL_VICTORY_SCREEN,
	CONTROL_INFO,
	CONTROL_GLOBE_VIEW,
	CONTROL_DETAILS,
	CONTROL_ADMIN_DETAILS,
	CONTROL_HALL_OF_FAME,
	CONTROL_WORLD_BUILDER,
	CONTROL_DIPLOMACY,
	CONTROL_SELECT_HEALTHY,
	CONTROL_FREE_COLONY,

#ifdef _USRDLL
	NUM_CONTROL_TYPES
#endif
};

enum DllExport PromotionTypes				
{
	NO_PROMOTION = -1,
};

enum DllExport HurryTypes						
{
	NO_HURRY = -1,
};

enum DllExport CultureLevelTypes		
{
	NO_CULTURELEVEL = -1,
};

enum DllExport CivicOptionTypes			
{
	NO_CIVICOPTION = -1,
};

enum DllExport CivicTypes						
{
	NO_CIVIC = -1,
};

enum DllExport WarPlanTypes					
{
	NO_WARPLAN = -1,

	WARPLAN_ATTACKED_RECENT,
	WARPLAN_ATTACKED,
	WARPLAN_PREPARING_LIMITED,
	WARPLAN_PREPARING_TOTAL,
	WARPLAN_LIMITED,
	WARPLAN_TOTAL,
	WARPLAN_DOGPILE,
	WARPLAN_EXTORTION,
	
#ifdef _USRDLL
	NUM_WARPLAN_TYPES
#endif
};

enum DllExport AreaAITypes					
{
	NO_AREAAI = -1,

	AREAAI_OFFENSIVE,
	AREAAI_BALANCED,
	AREAAI_DEFENSIVE,
	AREAAI_MASSING,
	AREAAI_ASSAULT,
	AREAAI_ASSAULT_MASSING,
	AREAAI_NEUTRAL,

#ifdef _USRDLL
	NUM_AREAAI_TYPES
#endif
};

enum DllExport EmotionTypes					
{
	NO_EMOTION = -1,

	EMOTION_GREED,
	EMOTION_ANGER,
	EMOTION_ENVY,
	EMOTION_ANXIETY,
	EMOTION_SUBMISSION,

#ifdef _USRDLL
	NUM_EMOTION_TYPES
#endif
};

enum DllExport StrategyTypes
{
	NO_STRATEGY = -1,
	
	STRATEGY_SMALL_WAVES,
	STRATEGY_BUILDUP,
	STRATEGY_CONCENTRATED_ATTACK,
	STRATEGY_DISTRIBUTED_ATTACK,
	
	STRATEGY_DIE_FIGHTING,
	
	STRATEGY_FAST_BELLS,
	STRATEGY_CASH_FOCUS,
	STRATEGY_SELL_TO_NATIVES,
	STRATEGY_DENSE_CITY_SPACING,
	
	STRATEGY_REVOLUTION_PREPARING,
	STRATEGY_REVOLUTION_DECLARING,
	STRATEGY_REVOLUTION,
#ifdef _USRDLL
	NUM_STRATEGY_TYPES
#endif

};

enum DllExport EndTurnButtonStates	
{
	END_TURN_GO,
	END_TURN_OVER_HIGHLIGHT,
	END_TURN_OVER_DARK,

#ifdef _USRDLL
	NUM_END_TURN_STATES
#endif
};

enum DllExport FogOfWarModeTypes		
{
	FOGOFWARMODE_OFF,
	FOGOFWARMODE_UNEXPLORED,
	FOGOFWARMODE_NOVIS,

#ifdef _USRDLL
	NUM_FOGOFWARMODE_TYPES
#endif
};

enum DllExport FogTypes
{
	FOG_TYPE_NONE,
	FOG_TYPE_PARALLEL,
	FOG_TYPE_PROJECTED,
	NUM_FOG_TYPES
};

enum DllExport CameraOverlayTypes
{
	CAMERA_OVERLAY_DECAL,
	CAMERA_OVERLAY_ADDITIVE,
	NUM_CAMERA_OVERLAY_TYPES
};

enum FOWUpdateTypes
{
	FOW_UPDATE_REGULAR,
	FOW_UPDATE_IMMEDIATE,
	FOW_UPDATE_UNDO_IMMEDIATE,
	FOW_UPDATE_FORCE_CHANGE,
	NUM_FOW_UPDATE_TYPES
};

// AnimationTypes is depreciated, and will be eventually removed.
// BONUSANIMATION_* and IMPROVEMENTANIMATION_* are still used, and will be left.

enum DllExport AnimationTypes			
{
	NONE_ANIMATION = -1,	// NO_ANIMATION is used by FirePlace

	BONUSANIMATION_UNIMPROVED = 1,
	BONUSANIMATION_NOT_WORKED,
	BONUSANIMATION_WORKED,

	IMPROVEMENTANIMATION_OFF = 2,
	IMPROVEMENTANIMATION_ON,
	IMPROVEMENTANIMATION_OFF_EXTRA,
	IMPROVEMENTANIMATION_ON_EXTRA_1,
	IMPROVEMENTANIMATION_ON_EXTRA_2,
	IMPROVEMENTANIMATION_ON_EXTRA_3,
	IMPROVEMENTANIMATION_ON_EXTRA_4,
};

enum DllExport EntityEventTypes		
{
	ENTITY_EVENT_NONE = -1,			//!< Invalid event
};

enum DllExport AnimationPathTypes	
{
	ANIMATIONPATH_NONE = -1,

	// Default animation paths
	ANIMATIONPATH_IDLE,
	ANIMATIONPATH_MOVE,
	ANIMATIONPATH_DAMAGE,				//!< Updates the damage state for the unit

	// Combat related animation paths
	ANIMATIONPATH_RANDOMIZE_ANIMATION_SET,
	ANIMATIONPATH_MELEE_STRIKE,
	ANIMATIONPATH_MELEE_HURT,
	ANIMATIONPATH_MELEE_DIE,
	ANIMATIONPATH_MELEE_FORTIFIED,
	ANIMATIONPATH_MELEE_DIE_FADE,		//!< Used only in combat. The colateral damage die should have a fade integrated.
	ANIMATIONPATH_MELEE_FLEE,			//!< Used only by settler children, so they don't die in combat
	
	// Ranged combat related animation paths
	ANIMATIONPATH_RANGED_STRIKE,
	ANIMATIONPATH_RANGED_DIE,
	ANIMATIONPATH_RANGED_FORTIFIED,
	ANIMATIONPATH_RANGED_RUNHIT,
	ANIMATIONPATH_RANGED_RUNDIE,
	ANIMATIONPATH_RANGED_DIE_FADE,		//!< Used only in combat. The colateral damage die should have a fade integrated.
	ANIMATIONPATH_LEADER_COMMAND,
	
	//mission related animation paths
	ANIMATIONPATH_HEAL,
	ANIMATIONPATH_SLEEP,
	ANIMATIONPATH_FORTIFY,
	ANIMATIONPATH_MELEE_FORTIFY,
	ANIMATIONPATH_PILLAGE,
	ANIMATIONPATH_SENTRY,
	ANIMATIONPATH_FOUND,
	ANIMATIONPATH_IRRIGATE,
	ANIMATIONPATH_BUILD,
	ANIMATIONPATH_MINE,
	ANIMATIONPATH_CHOP,
	ANIMATIONPATH_SHOVEL,
	ANIMATIONPATH_RAILROAD,
	ANIMATIONPATH_GREAT_EVENT,
	ANIMATIONPATH_SURRENDER,
};

//!<  Enumeration for the animation category types.
enum AnimationCategoryTypes			
{
	ANIMCAT_NONE = -1,
};

//!< Animation category operators.
enum AnimationOperatorTypes
{
	ANIMOP_FIRST = 1001,
	ANIMOP_RAND_FPR = ANIMOP_FIRST,			//!< Sets the FPR to a random number [0..1].
	ANIMOP_SET_FPR,							//!< Sets the FPR to the input value
	ANIMOP_SET_BR,							//!< Sets the BR to true the input value is non-zero
	ANIMOP_ADD_FPR,							//!< Adds the input value to the FPR register (input can be negative)
	ANIMOP_TEST_GT,							//!< Sets/resets the BR if the FPR is greater than the input
	ANIMOP_TEST_LT,							//!< Sets/resets the BR if the FPR is less than the input
	ANIMOP_LOAD_CAS,						//!< Sets the FPR to the CAS/32.
	ANIMOP_SET_ANIMATION_SET,						//!< Modifies the current animation set, by setting it to ((FPR*32)%32)
	ANIMOP_SKIP_IF,							//!< Skips the given number of instructions if the BR is true
	ANIMOP_CAS_INCR,						//!< Increments the CAS (and resets to zero if it is the maximum)
	ANIMOP_IS_RANGED,						//!< Sets the BR to true if the unit is "ranged", and to false otherwise
	ANIMOP_DEACTIVATE_DAMAGE_LAYERS,					//!< Deactivates all animations that are layered
	ANIMOP_SETCAS_DAMAGE,					//!< Set the current animation set to the damage level of the unit (damage/art define max)
	ANIMOP_LAST
};

enum DllExport CursorTypes							
{
	NO_CURSOR = -1,
};

enum DllExport FunctionTypes
{
	FUNC_NOINTERP = 0,	// NiAnimationKey::NOINTERP,
	FUNC_LINKEY,	//	= NiAnimationKey::LINKEY,
	FUNC_BEZKEY,	//	= NiAnimationKey::BEZKEY,
	FUNC_TCBKEY,	// = NiAnimationKey::TCBKEY,
	FUNC_EULERKEY,	// = NiAnimationKey::EULERKEY,
	FUNC_STEPKEY,	// = NiAnimationKey::STEPKEY,

#ifdef _USRDLL
	NUM_FUNC_TYPES	// = NiAnimationKey::NUMKEYTYPES
#endif
};

enum DllExport TradeableItems						
{
	TRADE_ITEM_NONE = -1,

	TRADE_GOLD,
	TRADE_MAPS,
	TRADE_OPEN_BORDERS,
	TRADE_DEFENSIVE_PACT,
	TRADE_PERMANENT_ALLIANCE,
	TRADE_PEACE_TREATY,

#ifdef _USRDLL
	NUM_BASIC_ITEMS,
	TRADE_YIELD = NUM_BASIC_ITEMS,
#else
	TRADE_YIELD,
#endif
	TRADE_CITIES,
	TRADE_PEACE,
	TRADE_WAR,
	TRADE_EMBARGO,

#ifdef _USRDLL
	NUM_TRADEABLE_HEADINGS,

	NUM_TRADEABLE_ITEMS = NUM_TRADEABLE_HEADINGS,
#endif
};

enum DllExport DiploEventTypes					
{
	NO_DIPLOEVENT = -1,

	DIPLOEVENT_CONTACT,
	DIPLOEVENT_AI_CONTACT,
	DIPLOEVENT_FAILED_CONTACT,
	DIPLOEVENT_GIVE_HELP,
	DIPLOEVENT_REFUSED_HELP,
	DIPLOEVENT_ACCEPT_DEMAND,
	DIPLOEVENT_REJECTED_DEMAND,
	DIPLOEVENT_DEMAND_WAR,
	DIPLOEVENT_JOIN_WAR,
	DIPLOEVENT_NO_JOIN_WAR,
	DIPLOEVENT_STOP_TRADING,
	DIPLOEVENT_NO_STOP_TRADING,
	DIPLOEVENT_ASK_HELP,
	DIPLOEVENT_MADE_DEMAND,
	DIPLOEVENT_TARGET_CITY,
	DIPLOEVENT_ACCEPT_TAX_RATE,
	DIPLOEVENT_REFUSE_TAX_RATE,
	DIPLOEVENT_ACCEPT_KING_GOLD,
	DIPLOEVENT_REFUSE_KING_GOLD,
	DIPLOEVENT_LIVE_AMONG_NATIVES,
	DIPLOEVENT_TRANSPORT_TREASURE,
	DIPLOEVENT_FOUND_CITY,
	//ray18
	DIPLOEVENT_ACQUIRE_CITY,
	//Ende ray18
	//TAC Native Mercs
	DIPLOEVENT_ACQUIRE_MERC,
	//End TAC Native Mercs
	//TAC Revolution Support
	DIPLOEVENT_REV_SUPPORT,
	//End TAC Revolution Support
	//TAC European Wars
	DIPLOEVENT_EUROPE_WAR,
	//End TAC European Wars
	DIPLOEVENT_FOUND_CITY_CHECK_NATIVES,

#ifdef _USRDLL
	NUM_DIPLOEVENT_TYPES
#endif
};

enum DllExport DiploCommentTypes				 
{
	NO_DIPLOCOMMENT = -1
};

enum DllExport NetContactTypes					 
{
	NO_NETCONTACT = -1,
	NETCONTACT_INITIAL,
	NETCONTACT_RESPONSE,
	NETCONTACT_ESTABLISHED,
	NETCONTACT_BUSY,

#ifdef _USRDLL
	NUM_NETCONTACT_TYPES
#endif
};

enum DllExport ContactTypes							 
{
	CONTACT_JOIN_WAR,
	CONTACT_STOP_TRADING,
	CONTACT_GIVE_HELP,
	CONTACT_ASK_FOR_HELP,
	CONTACT_DEMAND_TRIBUTE,
	CONTACT_OPEN_BORDERS,
	CONTACT_DEFENSIVE_PACT,
	CONTACT_PERMANENT_ALLIANCE,
	CONTACT_PEACE_TREATY,
	CONTACT_TRADE_MAP,
	CONTACT_YIELD_GIFT,

#ifdef _USRDLL
	NUM_CONTACT_TYPES
#endif
};

enum DllExport MemoryTypes							 
{
	MEMORY_DECLARED_WAR,
	MEMORY_DECLARED_WAR_ON_FRIEND,
	MEMORY_HIRED_WAR_ALLY,
	MEMORY_RAZED_CITY,
	MEMORY_GIVE_HELP,
	MEMORY_REFUSED_HELP,
	MEMORY_ACCEPT_DEMAND,
	MEMORY_REJECTED_DEMAND,
	MEMORY_ACCEPTED_JOIN_WAR,
	MEMORY_DENIED_JOIN_WAR,
	MEMORY_ACCEPTED_STOP_TRADING,
	MEMORY_DENIED_STOP_TRADING,
	MEMORY_STOPPED_TRADING,
	MEMORY_STOPPED_TRADING_RECENT,
	MEMORY_HIRED_TRADE_EMBARGO,
	MEMORY_MADE_DEMAND,
	MEMORY_MADE_DEMAND_RECENT,
	MEMORY_CANCELLED_OPEN_BORDERS,
	MEMORY_EVENT_GOOD_TO_US,
	MEMORY_EVENT_BAD_TO_US,
	MEMORY_LIBERATED_CITIES,
	MEMORY_REFUSED_TAX,
	MEMORY_REVENGE_TAKEN,
	MEMORY_MISSIONARY_FAIL,

#ifdef _USRDLL
	NUM_MEMORY_TYPES
#endif
};

enum DllExport AttitudeTypes				 
{
	NO_ATTITUDE = -1,

	ATTITUDE_FURIOUS,
	ATTITUDE_ANNOYED,
	ATTITUDE_CAUTIOUS,
	ATTITUDE_PLEASED,
	ATTITUDE_FRIENDLY,

#ifdef _USRDLL
	NUM_ATTITUDE_TYPES
#endif
};

//! Enumeration for playing events with CvLeaderheadWidget
enum DllExport LeaderheadAction			
{
	NO_LEADERANIM = -1,		//!< If used with CvLeaderheadWidget::PerformAction, plays the idle animation

	LEADERANIM_GREETING,		//!< The leaderhead greets you
	LEADERANIM_FRIENDLY,		//!< The leaderhead is friendly to you
	LEADERANIM_PLEASED,			//!< The leaderhead is pleased
	LEADERANIM_CAUTIOUS,		//!< The leaderhead is cautious
	LEADERANIM_ANNOYED,			//!< The leaderhead is annoyed
	LEADERANIM_FURIOUS,			//!< The leaderhead is furious
	LEADERANIM_DISAGREE,		//!< The leaderhead makes a disagree gesture
	LEADERANIM_AGREE,				//!< The leaderhead makes an agree gesture
	LEADERANIM_OFFER_PINKY,
	LEADERANIM_PINKY_IDLE,
	LEADERANIM_PINKY_ACCEPT,
	LEADERANIM_PINKY_REJECT,

#ifdef _USRDLL
	NUM_LEADERANIM_TYPES			//!< The number of leaderhead event types
#endif
};

enum DllExport DiplomacyPowerTypes	
{
	NO_DIPLOMACYPOWER		= -1,
	DIPLOMACYPOWER_WEAKER,
	DIPLOMACYPOWER_EQUAL,
	DIPLOMACYPOWER_STRONGER,

#ifdef _USRDLL
	NUM_DIPLOMACYPOWER_TYPES
#endif
};

enum DllExport FeatTypes						
{
	FEAT_TREASURE,
	FEAT_TREASURE_IN_PORT,
	FEAT_CITY_MISSING_YIELD,
	FEAT_CITY_NO_FOOD,
	FEAT_CITY_INLAND,
	FEAT_EUROPE_SHIPS,
	FEAT_GOTO_EUROPE,
	FEAT_TALK_NATIVES,
	FEAT_CITY_SCREEN,
	FEAT_PAD,

#ifdef _USRDLL
	NUM_FEAT_TYPES
#endif
};

enum DllExport SaveGameTypes			
{
	SAVEGAME_NONE = -1,
	
	SAVEGAME_AUTO,
	SAVEGAME_RECOVERY,
	SAVEGAME_QUICK,
	SAVEGAME_NORMAL,
	SAVEGAME_GROUP,
	SAVEGAME_DROP_QUIT,
	SAVEGAME_DROP_CONTINUE,
	SAVEGAME_PBEM,
	SAVEGAME_REPLAY,

#ifdef _USRDLL
	NUM_SAVEGAME_TYPES
#endif
};

enum DllExport InitializationStates
{
	INIT_OK,
	INIT_FAILED,

#ifdef _USRDLL
	NUM_INIT_STATES
#endif
};

enum DllExport GameType				
{
	GAME_NONE = -1,

	GAME_SP_NEW,
	GAME_SP_SCENARIO,
	GAME_SP_LOAD,
	GAME_MP_NEW,
	GAME_MP_SCENARIO,
	GAME_MP_LOAD,
	GAME_HOTSEAT_NEW,
	GAME_HOTSEAT_SCENARIO,
	GAME_HOTSEAT_LOAD,
	GAME_PBEM_NEW,
	GAME_PBEM_SCENARIO,
	GAME_PBEM_LOAD,
	GAME_REPLAY,

#ifdef _USRDLL
	NUM_GAMETYPES
#endif
};

enum DllExport GameMode				
{
	NO_GAMEMODE = -1,

	GAMEMODE_NORMAL,
	GAMEMODE_PITBOSS,

#ifdef _USRDLL
	NUM_GAMEMODES
#endif
};

enum DllExport GamePwdTypes
{
	NO_PWDTYPE = -1,

	PWD_NEWGAME,
	PWD_SCENARIO,
	PWD_JOINGAME,

#ifdef _USRDLL
	NUM_PWDTYPES
#endif
};

enum DllExport SlotClaim
{
	SLOTCLAIM_UNASSIGNED,
	SLOTCLAIM_RESERVED,
	SLOTCLAIM_ASSIGNED,

#ifdef _USRDLL
	NUM_SLOTCLAIMS
#endif
};

enum DllExport SlotStatus
{
	SS_OPEN,
	SS_COMPUTER,
	SS_CLOSED,
	SS_TAKEN,

	SS_MAX_SLOT_STATUS,
};

enum DllExport InterfaceVisibility				
{
	INTERFACE_SHOW,
	INTERFACE_HIDE,
	INTERFACE_HIDE_ALL,
	INTERFACE_MINIMAP_ONLY,
	INTERFACE_ADVANCED_START,
};

enum DllExport GenericButtonSizes					
{
	BUTTON_SIZE_46,
	BUTTON_SIZE_32,
	BUTTON_SIZE_24,
	BUTTON_SIZE_16,

	BUTTON_SIZE_CUSTOM,
};

enum DllExport MenuScreenType
{
	MENU_SCREEN_STANDARD,
	MENU_SCREEN_BASELOBBY,
	MENU_SCREEN_BASE_SCENARIO,
	MENU_SCREEN_JOIN,
	MENU_SCREEN_BASE_LOAD,
	MENU_SCREEN_LAUNCHING,
	MENU_SCREEN_BASE_INIT,

	MENU_SCREEN_OPENING_MENU,
	MENU_SCREEN_MOD_MENU,

	MENU_SCREEN_GS_BUDDYLIST, 
	MENU_SCREEN_GS_CHATROOM,
	MENU_SCREEN_GS_CHANNEL,
	MENU_SCREEN_GS_CHOOSE_SCENARIO,
	MENU_SCREEN_GS_SCENARIO,
	MENU_SCREEN_GS_NAVBAR,
	MENU_SCREEN_GS_LOAD_STAGING,
	MENU_SCREEN_GS_MOTD,
	MENU_SCREEN_GS_LOGIN,
	MENU_SCREEN_GS_LOAD,
	MENU_SCREEN_GS_JOIN,
	MENU_SCREEN_GS_INIT,
	MENU_SCREEN_GS_CUSTOM_GAMES,

	MENU_SCREEN_LANLOBBY,
	MENU_SCREEN_MP_CHOOSE_SCENARIO,
	MENU_SCREEN_MP_SCENARIO,
	MENU_SCREEN_MP_LOAD_STAGING,
	MENU_SCREEN_MP_LOAD,
	MENU_SCREEN_MP_INIT,
	MENU_SCREEN_MP_CHOICES,
	MENU_SCREEN_MP_JOIN,

	MENU_SCREEN_SP_WORLD_SIZE,
	MENU_SCREEN_SP_SCENARIO,
	MENU_SCREEN_SP_LOAD,
	MENU_SCREEN_SP_INIT,
	MENU_SCREEN_SP_CHOICES,
	MENU_SCREEN_SP_ADVANCED_LOAD,
	MENU_SCREEN_SP_SIMPLE_CIV_PICKER,
	MENU_SCREEN_SP_REPLAY,
	MENU_SCREEN_SP_MAP_SCRIPT,
	MENU_SCREEN_SP_DIFFICULTY,
};

enum DllExport WorldBuilderPopupTypes			
{
	WBPOPUP_NONE = -1,

	WBPOPUP_START = 200,
	WBPOPUP_CITY=WBPOPUP_START,		// first entry, starts at 0
	WBPOPUP_UNIT,
	WBPOPUP_PLAYER,
	WBPOPUP_PLOT,
	WBPOPUP_TERRAIN,
	WBPOPUP_FEATURE,
	WBPOPUP_IMPROVEMENT,
	WBPOPUP_GAME,

#ifdef _USRDLL
	NUM_WBPOPUP
#endif
};

enum DllExport EventType									
{
	// mouseEvent
	EVT_LBUTTONDOWN = 1,
	EVT_LBUTTONDBLCLICK,
	EVT_RBUTTONDOWN,
	EVT_BACK,
	EVT_FORWARD,

	// kbdEvent
	EVT_KEYDOWN,
	EVT_KEYUP,
};

// Different types of load
enum DllExport LoadType										
{
	LOAD_NORMAL,
	LOAD_INIT,
	LOAD_SETUP,
	LOAD_GAMETYPE,
	LOAD_REPLAY,
	LOAD_NORMAL_AND_GAMETYPE,
};

//	Available Fonts
enum DllExport FontTypes									
{
	TITLE_FONT,
	GAME_FONT,
	SMALL_FONT,
	MENU_FONT,
	MENU_HIGHLIGHT_FONT,
};

enum DllExport PanelStyles								
{
	// Built in styles
	PANEL_STYLE_STANDARD,
	PANEL_STYLE_SOLID,
	PANEL_STYLE_EMPTY,
	PANEL_STYLE_FLAT,
	PANEL_STYLE_IN,
	PANEL_STYLE_OUT,
	PANEL_STYLE_EXTERNAL,
	PANEL_STYLE_DEFAULT,

	// Civ specific styles
	PANEL_STYLE_CIVILPEDIA,
	PANEL_STYLE_STONE,
	PANEL_STYLE_UNITSTAT,
	PANEL_STYLE_BLUELARGE,
	PANEL_STYLE_BLUE50,

	PANEL_STYLE_TOPBAR,
	PANEL_STYLE_BOTTOMBAR,
	PANEL_STYLE_TECH,

	PANEL_STYLE_GAMEHUD_LEFT,
	PANEL_STYLE_GAMEHUD_RIGHT,
	PANEL_STYLE_GAMEHUD_CENTER,
	PANEL_STYLE_GAMEHUD_STATS,
	PANEL_STYLE_GAME_MAP,
	PANEL_STYLE_GAME_TOPBAR,
	PANEL_STYLE_HUD_HELP,

	PANEL_STYLE_CITY_LEFT,
	PANEL_STYLE_CITY_RIGHT,
	PANEL_STYLE_CITY_TOP,
	PANEL_STYLE_CITY_TANSHADE,
	PANEL_STYLE_CITY_INFO,
	PANEL_STYLE_CITY_TANTL,
	PANEL_STYLE_CITY_TANTR,
	PANEL_STYLE_CITY_COLUMNL,
	PANEL_STYLE_CITY_COLUMNC,
	PANEL_STYLE_CITY_COLUMNR,
	PANEL_STYLE_CITY_TITLE,

	PANEL_STYLE_DAWN,
	PANEL_STYLE_DAWNTOP,
	PANEL_STYLE_DAWNBOTTOM,

	PANEL_STYLE_MAIN,
	PANEL_STYLE_MAIN_BLACK25,
	PANEL_STYLE_MAIN_BLACK50,
	PANEL_STYLE_MAIN_WHITE,
	PANEL_STYLE_MAIN_WHITETAB,
	PANEL_STYLE_MAIN_TAN,
	PANEL_STYLE_MAIN_TAN15,
	PANEL_STYLE_MAIN_TANL,
	PANEL_STYLE_MAIN_TANR,
	PANEL_STYLE_MAIN_TANT,
	PANEL_STYLE_MAIN_TANB,
	PANEL_STYLE_MAIN_BOTTOMBAR,
	PANEL_STYLE_MAIN_SELECT,
};

enum DllExport ButtonStyles								
{
	BUTTON_STYLE_STANDARD,
	BUTTON_STYLE_ETCHED,
	BUTTON_STYLE_FLAT,
	BUTTON_STYLE_IMAGE,
	BUTTON_STYLE_LABEL,
	BUTTON_STYLE_LINK,
	BUTTON_STYLE_SQUARE,
	BUTTON_STYLE_TOOL,
	BUTTON_STYLE_DEFAULT,

	// Civ specific styles
	BUTTON_STYLE_CIRCLE,
	BUTTON_STYLE_CITY_B01,
	BUTTON_STYLE_CITY_B02TL,
	BUTTON_STYLE_CITY_B02TR,
	BUTTON_STYLE_CITY_B02BL,
	BUTTON_STYLE_CITY_B02BR,
	BUTTON_STYLE_CITY_B03TL,
	BUTTON_STYLE_CITY_B03TC,
	BUTTON_STYLE_CITY_B03TR,
	BUTTON_STYLE_CITY_B03BL,
	BUTTON_STYLE_CITY_B03BC,
	BUTTON_STYLE_CITY_B03BR,
	BUTTON_STYLE_CITY_FLAT,
	BUTTON_STYLE_CITY_PLUS,
	BUTTON_STYLE_CITY_MINUS,

	BUTTON_STYLE_ARROW_LEFT,
	BUTTON_STYLE_ARROW_RIGHT,
	BUTTON_STYLE_ARROW_UP,
	BUTTON_STYLE_ARROW_DOWN
};

enum DllExport ImageShapes								
{
	IMAGE_SHAPE_RECTANGLE,
	IMAGE_SHAPE_ELLIPSE,
	IMAGE_SHAPE_PARABOLA_TOP,
};

enum DllExport TableStyles								
{
	TABLE_STYLE_STANDARD,
	TABLE_STYLE_EMPTY,
	TABLE_STYLE_ALTEMPTY,
	TABLE_STYLE_CITY,
	TABLE_STYLE_EMPTYSELECTINACTIVE,
	TABLE_STYLE_ALTDEFAULT,
	TABLE_STYLE_STAGINGROOM
};

enum DllExport EventContextTypes					
{
	NO_EVENTCONTEXT = -1,

	EVENTCONTEXT_SELF,
	EVENTCONTEXT_ALL,
};

enum DllExport CivLoginStates
{
	NO_CIV_LOGIN = -1,

	LOGIN_CIV_OK,
	LOGIN_CIV_BAD_PWD,
	LOGIN_CIV_TAKEN,
	LOGIN_CIV_HAS_ID,
};
 
enum DllExport VersionTypes
{
	NO_VERSIONTYPE = -1,

	VERSIONTYPE_EXE,
	VERSIONTYPE_DLL,
	VERSIONTYPE_SHADERS,
	VERSIONTYPE_PYTHON,
	VERSIONTYPE_XML,
};

enum DllExport VoteResultTypes
{
	VOTERESULT_MAJORITY,
	VOTERESULT_UNANIMOUS,
};

enum DllExport VoteStatusTypes
{
	NO_VOTESTATUS = -1, 

	VOTESTATUS_TIED = -2,
	VOTESTATUS_UNDECIDED = -3,
	VOTESTATUS_INCOMPLETE = -4
};

// Tab Group in Options Menu
enum DllExport TabGroupTypes				
{
	NO_TABGROUP = -1,

	TABGROUP_GAME,
	TABGROUP_INPUT,
	TABGROUP_GRAPHICS,
	TABGROUP_AUDIO,
	TABGROUP_CLOCK,

#ifdef _USRDLL
	NUM_TABGROUPS
#endif
};

enum DllExport ReplayMessageTypes		
{
	NO_REPLAY_MESSAGE = -1,

	REPLAY_MESSAGE_MAJOR_EVENT,
	REPLAY_MESSAGE_CITY_FOUNDED,
	REPLAY_MESSAGE_PLOT_OWNER_CHANGE,

#ifdef _USRDLL
	NUM_REPLAY_MESSAGE_TYPES
#endif
};

/*------------------------------------------------------------------------------------
Enum:		EAudioTag
Purpose:	To enumerate all of the tag strings loaded from the csv or xml files
------------------------------------------------------------------------------------*/
enum DllExport AudioTag							
{
	AUDIOTAG_NONE = -1,
	AUDIOTAG_SOUNDID,
	AUDIOTAG_CONTEXTID,
	AUDIOTAG_SOUNDTYPE,
	AUDIOTAG_2DSCRIPT,
	AUDIOTAG_3DSCRIPT,
	AUDIOTAG_SOUNDSCAPE,
	AUDIOTAG_POSITION,
	AUDIOTAG_SCRIPTTYPE,
	AUDIOTAG_LOADTYPE,
	AUDIOTAG_COUNT,
};

enum DllExport CivilopediaPageTypes		
{
	NO_CIVILOPEDIA_PAGE = -1,

	CIVILOPEDIA_PAGE_UNIT,
	CIVILOPEDIA_PAGE_PROFESSION,
	CIVILOPEDIA_PAGE_FATHER,
	CIVILOPEDIA_PAGE_BUILDING,
	CIVILOPEDIA_PAGE_TERRAIN,
	CIVILOPEDIA_PAGE_YIELDS,
	CIVILOPEDIA_PAGE_FEATURE,
	CIVILOPEDIA_PAGE_BONUS,
	CIVILOPEDIA_PAGE_IMPROVEMENT,
	CIVILOPEDIA_PAGE_PROMOTION,
	CIVILOPEDIA_PAGE_CIV,
	CIVILOPEDIA_PAGE_LEADER,
	CIVILOPEDIA_PAGE_CIVIC,
	CIVILOPEDIA_PAGE_CONCEPT,
	CIVILOPEDIA_PAGE_HINTS,

#ifdef _USRDLL
	NUM_CIVILOPEDIA_PAGE_TYPES
#endif
};

enum DllExport ActionSubTypes					
{
	NO_ACTIONSUBTYPE = -1,

	ACTIONSUBTYPE_INTERFACEMODE,
	ACTIONSUBTYPE_COMMAND,
	ACTIONSUBTYPE_BUILD,
	ACTIONSUBTYPE_PROMOTION,
	ACTIONSUBTYPE_UNIT,
	ACTIONSUBTYPE_CONTROL,
	ACTIONSUBTYPE_AUTOMATE,
	ACTIONSUBTYPE_MISSION,

#ifdef _USRDLL
	NUM_ACTIONSUBTYPES
#endif
};

enum DllExport GameMessageTypes				
{
	GAMEMESSAGE_NETWORK_READY,
	GAMEMESSAGE_SAVE_GAME_FLAG,
	GAMEMESSAGE_SAVE_FLAG_ACK,
	GAMEMESSAGE_VERIFY_VERSION,
	GAMEMESSAGE_VERSION_NACK,
	GAMEMESSAGE_VERSION_WARNING,
	GAMEMESSAGE_GAME_TYPE,
	GAMEMESSAGE_ID_ASSIGNMENT,
	GAMEMESSAGE_FILE_INFO,
	GAMEMESSAGE_PICK_YOUR_CIV,
	GAMEMESSAGE_CIV_CHOICE,
	GAMEMESSAGE_CONFIRM_CIV_CLAIM, 
	GAMEMESSAGE_CLAIM_INFO,
	GAMEMESSAGE_CIV_CHOICE_ACK,
	GAMEMESSAGE_CIV_CHOICE_NACK,
	GAMEMESSAGE_CIV_CHOSEN,
	GAMEMESSAGE_INTERIM_NOTICE,
	GAMEMESSAGE_INIT_INFO,
	GAMEMESSAGE_MAPSCRIPT_CHECK,
	GAMEMESSAGE_MAPSCRIPT_ACK,
	GAMEMESSAGE_LOAD_GAME,
	GAMEMESSAGE_PLAYER_ID,
	GAMEMESSAGE_SLOT_REASSIGNMENT,
	GAMEMESSAGE_PLAYER_INFO,
	GAMEMESSAGE_GAME_INFO,
	GAMEMESSAGE_REASSIGN_PLAYER,
	GAMEMESSAGE_PITBOSS_INFO,
	GAMEMESSAGE_LAUNCHING_INFO,
	GAMEMESSAGE_INIT_GAME,
	GAMEMESSAGE_INIT_PLAYERS,
	GAMEMESSAGE_AUTH_REQUEST,
	GAMEMESSAGE_AUTH_RESPONSE,
	GAMEMESSAGE_SYNCH_START,
	GAMEMESSAGE_EXTENDED_GAME,
	GAMEMESSAGE_JOIN_GROUP,
	GAMEMESSAGE_PUSH_MISSION,
	GAMEMESSAGE_AUTO_MISSION,
	GAMEMESSAGE_DO_COMMAND,
	GAMEMESSAGE_PUSH_ORDER,
	GAMEMESSAGE_POP_ORDER,
	GAMEMESSAGE_DO_TASK,
	GAMEMESSAGE_CHAT,
	GAMEMESSAGE_PING,
	GAMEMESSAGE_SIGN,
	GAMEMESSAGE_LINE_ENTITY,
	GAMEMESSAGE_SIGN_DELETE,
	GAMEMESSAGE_LINE_ENTITY_DELETE,
	GAMEMESSAGE_LINE_GROUP_DELETE,
	GAMEMESSAGE_PAUSE,
	GAMEMESSAGE_MP_KICK,
	GAMEMESSAGE_MP_RETIRE,
	GAMEMESSAGE_CLOSE_CONNECTION,
	GAMEMESSAGE_NEVER_JOINED,
	GAMEMESSAGE_MP_DROP_INIT,
	GAMEMESSAGE_MP_DROP_VOTE,
	GAMEMESSAGE_MP_DROP_UPDATE,
	GAMEMESSAGE_MP_DROP_RESULT,
	GAMEMESSAGE_MP_DROP_SAVE,
	GAMEMESSAGE_TOGGLE_TRADE,
	GAMEMESSAGE_IMPLEMENT_OFFER,
	GAMEMESSAGE_CHANGE_WAR,
	GAMEMESSAGE_APPLY_EVENT,
	GAMEMESSAGE_CONTACT_CIV,
	GAMEMESSAGE_DIPLO_CHAT,
	GAMEMESSAGE_SEND_OFFER,
	GAMEMESSAGE_DIPLO_EVENT,
	GAMEMESSAGE_RENEGOTIATE,
	GAMEMESSAGE_RENEGOTIATE_ITEM,
	GAMEMESSAGE_EXIT_TRADE,
	GAMEMESSAGE_KILL_DEAL,
	GAMEMESSAGE_SAVE_GAME,
	GAMEMESSAGE_UPDATE_CIVICS,
	GAMEMESSAGE_CLEAR_TABLE,
	GAMEMESSAGE_POPUP_PROCESSED,
	GAMEMESSAGE_DIPLOMACY_PROCESSED,
	GAMEMESSAGE_HOT_JOIN_NOTICE,
	GAMEMESSAGE_HOT_DROP_NOTICE,
	GAMEMESSAGE_DIPLOMACY,
	GAMEMESSAGE_POPUP,
	GAMEMESSAGE_ADVANCED_START_ACTION,
	GAMEMESSAGE_PLAYER_ACTION,
	GAMEMESSAGE_MOD_NET_MESSAGE
};

enum DllExport PopupControlLayout		
{
	POPUP_LAYOUT_LEFT,
	POPUP_LAYOUT_CENTER,
	POPUP_LAYOUT_RIGHT,
	POPUP_LAYOUT_STRETCH,
	POPUP_LAYOUT_TOP,

	POPUP_LAYOUT_NUMLAYOUTS
};

enum DllExport JustificationTypes		
{
	DLL_FONT_LEFT_JUSTIFY = 1<<0,
	DLL_FONT_RIGHT_JUSTIFY = 1<<1,
	DLL_FONT_CENTER_JUSTIFY = 1<<2,
	DLL_FONT_CENTER_VERTICALLY = 1<<3,
	DLL_FONT_ADDITIVE = 1<<4,
};

enum DllExport ToolTipAlignTypes		
{
	TOOLTIP_TOP_LEFT,
	TOOLTIP_TOP_INLEFT,
	TOOLTIP_TOP_CENTER,
	TOOLTIP_TOP_INRIGHT,
	TOOLTIP_TOP_RIGHT,

	TOOLTIP_INTOP_RIGHT,
	TOOLTIP_CENTER_RIGHT,
	TOOLTIP_INBOTTOM_RIGHT,

	TOOLTIP_BOTTOM_RIGHT,
	TOOLTIP_BOTTOM_INRIGHT,
	TOOLTIP_BOTTOM_CENTER,
	TOOLTIP_BOTTOM_INLEFT,
	TOOLTIP_BOTTOM_LEFT,

	TOOLTIP_INBOTTOM_LEFT,
	TOOLTIP_CENTER_LEFT,
	TOOLTIP_INTOP_LEFT,
};

enum DllExport ActivationTypes			
{
	ACTIVATE_NORMAL,
	ACTIVATE_CHILDFOCUS,
	ACTIVATE_MIMICPARENT,
	ACTIVATE_MIMICPARENTFOCUS,
};

enum DllExport HitTestTypes					
{
	HITTEST_DEFAULT,
	HITTEST_ON,
	HITTEST_SOLID,
	HITTEST_CHILDREN,
	HITTEST_NOHIT,
};

enum DllExport GraphicLevelTypes		
{
	GRAPHICLEVEL_HIGH,
	GRAPHICLEVEL_MEDIUM,
	GRAPHICLEVEL_LOW,
	GRAPHICLEVEL_CURRENT,
	GRAPHICLEVEL_BELOW_SPEC,

#ifdef _USRDLL
	NUM_GRAPHICLEVELS
#endif
};

enum DllExport EventTypes		
{
	NO_EVENT = -1,
};

enum DllExport EventTriggerTypes		
{
	NO_EVENTTRIGGER = -1,
};

enum DllExport AdvancedStartActionTypes				
{
	NO_ADVANCEDSTARTACTION = -1,

	ADVANCEDSTARTACTION_EXIT,
	ADVANCEDSTARTACTION_UNIT,
	ADVANCEDSTARTACTION_CITY,
	ADVANCEDSTARTACTION_POP,
	ADVANCEDSTARTACTION_CULTURE,
	ADVANCEDSTARTACTION_BUILDING,
	ADVANCEDSTARTACTION_IMPROVEMENT,
	ADVANCEDSTARTACTION_ROUTE,
	ADVANCEDSTARTACTION_VISIBILITY,
	ADVANCEDSTARTACTION_AUTOMATE,

#ifdef _USRDLL
	NUM_ADVANCEDSTARTACTIONS
#endif
};

enum DllExport UnitTravelStates			
{
	NO_UNIT_TRAVEL_STATE = -1,

	UNIT_TRAVEL_STATE_TO_EUROPE,
	UNIT_TRAVEL_STATE_IN_EUROPE,
	UNIT_TRAVEL_STATE_FROM_EUROPE,

	UNIT_TRAVEL_STATE_LIVE_AMONG_NATIVES,

#ifdef _USRDLL
	NUM_UNIT_TRAVEL_STATES
#endif
};

enum DllExport UnitAIStates
{
	NO_UNITAI_STATE = -1,
	
	UNITAI_STATE_DEFAULT,
	UNITAI_STATE_BEARING_GIFTS,
	UNITAI_STATE_RETURN_HOME,
	UNITAI_STATE_WANDER,
	
	UNITAI_STATE_GUARDING,
	UNITAI_STATE_ADVANCING,
	UNITAI_STATE_GROUPING,
	UNITAI_STATE_CHARGING,
	UNITAI_STATE_RETREATING,
	
	UNITAI_STATE_PICKUP,
	
	UNITAI_STATE_PURCHASED,
	UNITAI_STATE_SELL_TO_NATIVES,
	UNITAI_STATE_SAIL,
	
	NUM_UNITAI_STATES,
};

enum DllExport FatherCategoryTypes							 
{
	NO_FATHERCATEGORY = -1,
};

enum DllExport FatherTypes							 
{
	NO_FATHER = -1,
};

enum DllExport FatherPointTypes
{
	NO_FATHER_POINT_TYPE = -1,

};

enum DllExport AlarmTypes				
{
	NO_ALARM = -1,
};


// PatchMod: Achievements START
enum DllExport AchieveTypes				
{
	NO_ACHIEVE = -1,
};
// PatchMod: Achievements END

// TAC - Trade Messages - koma13 - START
enum DllExport TradeMessageTypes
{
	NO_TRADE_MESSAGE = -1,
	TRADE_MESSAGE_EUROPE_YIELD_SOLD,
	TRADE_MESSAGE_EUROPE_YIELD_BOUGHT,
	TRADE_MESSAGE_TREASURE,
	TRADE_MESSAGE_LACK_FUNDS,

	NUM_TRADE_MESSAGES,
};
// TAC - Trade Messages - koma13 - END

#endif	// CVENUMS_h
